' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.
Imports System

''' <summary>
''' Klasa Bug jest gwna jednostk w systemie reprezentujc zgoszony bd w aplikacji
''' </summary>
''' <remarks>Sama klasa Bug posiada tylko waciwoci, nie wykonuje adnych czynnoci. W klasie <see cref="BugManager">BugManager</see> moesz zobaczy list operacji, ktre mog by wykonywane w stosunku do bdw.</remarks>
Public Class Bug

#Region "Zmienne prywatne"

  Private _id As Integer = -1
  Private _title As String = String.Empty
  Private _description As String = String.Empty
  Private _priority As Integer = 3
  Private _application As NameValue = New NameValue
  Private _severity As NameValue = New NameValue
  Private _reproducibility As NameValue = New NameValue
  Private _feature As NameValue = New NameValue
  Private _frequency As NameValue = New NameValue
  Private _status As NameValue = New NameValue
  Private _createdDateAndTime As DateTime = DateTime.MinValue
  Private _updatedDateAndTime As DateTime = DateTime.MinValue
  Private _createMemberId As Guid = Guid.Empty
  Private _updateMemberId As Guid = Guid.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Domylny konstruktor dla bdu. Tworzy pusty obiekt bdu.
  ''' </summary>
  Public Sub New()

  End Sub

  ''' <summary>
  ''' Przeciony konstruktor klasy Bug. Tworzy pusty bd i ustawia wewntrzny identyfikator.
  ''' Uywany w sytuacji, gdy istniejce bdy maj byc zmienione.
  ''' </summary>
  Public Sub New(ByVal id As Integer)
    Me._id = id
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Identyfikator bdu w bazie danych. Uywany do jednoznacznego okrelenia bdu.
  ''' </summary>
  Public Property Id() As Integer
    Get
      Return _id
    End Get
    Set(ByVal value As Integer)
      _id = value
    End Set
  End Property

  ''' <summary>
  ''' Nazwa lub krtki opis bdu.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _title
    End Get
    Set(ByVal value As String)
      _title = value
    End Set
  End Property

  ''' <summary>
  ''' Dugi tekst opisujcy bd.
  ''' </summary>
  Public Property Description() As String
    Get
      Return _description
    End Get
    Set(ByVal value As String)
      _description = value
    End Set
  End Property

  ''' <summary>
  ''' Identyfikator aplikacji, dla ktrej zgaszamy bd.
  ''' </summary>
  Public Property Application() As NameValue
    Get
      Return _application
    End Get
    Set(ByVal value As NameValue)
      _application = value
    End Set
  End Property

  ''' <summary>
  ''' Funkcja aplikacji, do ktrej odnosi si bd.
  ''' </summary>
  Public Property Feature() As NameValue
    Get
      Return _feature
    End Get
    Set(ByVal value As NameValue)
      _feature = value
    End Set
  End Property

  ''' <summary>
  ''' Waciwo Frequency okrela jak czsto okreslony bd wystpuje podczas normalnego uytkowania.
  ''' </summary>
  Public Property Frequency() As NameValue
    Get
      Return _frequency
    End Get
    Set(ByVal value As NameValue)
      _frequency = value
    End Set
  End Property

  ''' <summary>
  ''' Wlaciwo Severity okrela wpyw bdu na aplikacj.
  ''' </summary>
  Public Property Severity() As NameValue
    Get
      Return _severity
    End Get
    Set(ByVal value As NameValue)
      _severity = value
    End Set
  End Property

  ''' <summary>
  ''' Waciwo Reproducibility wskazuje, czy bad mone by (atwo) odtworzony.
  ''' </summary>
  Public Property Reproducibility() As NameValue
    Get
      Return _reproducibility
    End Get
    Set(ByVal value As NameValue)
      _reproducibility = value
    End Set
  End Property

  ''' <summary>
  ''' Biecy status bdu w Bazie Bdw.
  ''' </summary>
  Public Property Status() As NameValue
    Get
      Return _status
    End Get
    Set(ByVal value As NameValue)
      _status = value
    End Set
  End Property

  ''' <summary>
  ''' Priorytet bdu. Zostaje przypisany do bdu po jego przejrzeniu.
  ''' </summary>
  Public Property Priority() As Integer
    Get
      Return _priority
    End Get
    Set(ByVal value As Integer)
      If value < 1 OrElse value > 5 Then
        Throw New ArgumentException("Priorytet bdu moe mie warto od 1 do 5. Bieca warto " & value.ToString + " nie jest dozwolona.")
      Else
        _priority = value
      End If
    End Set
  End Property

  ''' <summary>
  ''' Data i czas utworzenia bdu.
  ''' </summary>
  Public Property CreatedDateAndTime() As DateTime
    Get
      Return _createdDateAndTime
    End Get
    Set(ByVal value As DateTime)
      _createdDateAndTime = value
    End Set
  End Property

  ''' <summary>
  ''' Data i czas ostatniej modyfikacji bdu.
  ''' </summary>
  Public Property UpdatedDateAndTime() As DateTime
    Get
      Return _updatedDateAndTime
    End Get
    Set(ByVal value As DateTime)
      _updatedDateAndTime = value
    End Set
  End Property

  ''' <summary>
  ''' Identyfikator czonka zespou, ktry wprowadzi bd do bazy.
  ''' </summary>
  Public Property CreateMemberId() As Guid
    Get
      Return _createMemberId
    End Get
    Set(ByVal value As Guid)
      _createMemberId = value
    End Set
  End Property

  ''' <summary>
  ''' Identyfikator czonka zespou, ktry aktualizowa dany bd jako ostatni.
  ''' </summary>
  Public Property UpdateMemberId() As Guid
    Get
      Return _updateMemberId
    End Get
    Set(ByVal value As Guid)
      _updateMemberId = value
    End Set
  End Property

#End Region

End Class